turtles-own
[ new? ]

globals
[
  len
  swirl?
  ball?
  tree1?
  tree2?
  sierpinski?
  koch?
  figureEight?
  first-time-through?
]

to setup
  ca
  crt 1
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy init-x init-y
    set heading 0
    pd
  ]
  set len 64
  set swirl? false
  set ball? false
  set tree1? false
  set tree2? false
  set sierpinski? false
  set koch? false
  set figureEight? false
end

to iterate
  ask turtles
  [
    set new? false
    pd
  ]
  ifelse (swirl?)
  [ swirl ]
  [
    ifelse (ball?)
    [ ball ]
    [
      ifelse (tree1?)
      [ tree1 ]
      [
        ifelse (tree2?)
        [ tree2 ]
        [
          ifelse (sierpinski?)
          [ sierpinskiTree ]
          [
            ifelse (koch?)
            [ kochSnowflake ]
            [
              ifelse (figureEight?)
              [ figureEightCovering ]
              [ applyRules ]
            ]
          ]
        ]
      ]
    ]
  ]
end

;write your own rules for the l-system fractal here.  for commands either read the documentation in this file or 
;follow the directions found in the information file.  briefly,
;    "t" causes every non-new turtle to create a new turtle with the same heading
;    "r <number>" causes every non-new turtle to turn to the right by number degrees
;    "l <number>" causes every non-new turtle to turn to the left by number degrees
;    "ahead <number>" causes every non-new turtle to draw a line of length number in the direction each is heading
;    "f" causes every non-new turtle to draw line of length 1 in the direction each is heading
;    "skip <number>" causes every non-new turtle to move forward by number in the direction each is heading without drawing
;    "s" causes every non-new turtle to move forward by 1 in the direction each is heading without drawing
to applyRules
;enter your rules here
  f f f r 15 t f f f l 30 f f f
;stop entering in rules
end

;hatch a new turtle for all the turtles that are not new to the current iteration and set new? to be true
;further for all those turtles that do create another turtle, change their color by adding to color color-inc
to t
  ask turtles with [not new?] [hatch 1 [set new? true] set color color + color-inc]
end

;turn each turtle that wasn't created during the current iteration to the right by degree degrees
to r [degree]
  ask turtles with [not new?] [rt degree]
end

;turn each turtle that wasn't created during the current iteration to the left by degree degrees
to l [degree]
  ask turtles with [not new?] [lt degree]
end

;move each turtle that wasn't created during the current iteration forward by steps
to ahead [steps]
  ask turtles with [not new?] [fd steps]
end

;move each turtle that wasn't created during the current iteration forward by 1
to f
  ask turtles with [not new?] [fd 1]
end

;move each turtle that wasn't created during the current iteration forward by 1 but do not draw
to s
  ask turtles with [not new?] [pu fd 1 pd]
end

;move each turtle that wasn't created during the current iteration forward by steps but do not draw
to skip [steps]
  ask turtles with [not new?] [pu fd steps pd]
end

;destroys all non-new turtles
to d
  ask turtles with [not new?] [die]
end

;-----------------------------
;        example buttons
;-----------------------------

to swirlSetup
  ca
  crt 1
  set color-inc 9.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy 0 0
    set heading 0
    pd
  ]
  set len 50
  set swirl? true
  set ball? false
  set tree1? false
  set tree2? false
  set sierpinski? false
  set koch? false
  set figureEight? false
end

to swirl
  ask turtles [set new? false pd]
  f f f r 10 t s s s l 60 ahead 5
end

to ballSetup
  ca
  crt 1
  set color-inc 9.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy 0 0
    set heading 0
    pd
  ]
  set len 50
  set swirl? false
  set ball? true
  set tree1? false
  set tree2? false
  set sierpinski? false
  set koch? false
  set figureEight? false
end

to ball
  ask turtles [set new? false pd]
  f f r 45 t s s s l 45 f f f l 45
end

to tree1Setup
  ca
  crt 1
  set color-inc 9.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy 0 -10
    set heading 0
    pd
  ]
  set len 50
  set swirl? false
  set ball? false
  set tree1? true
  set tree2? false
  set sierpinski? false
  set koch? false
  set figureEight? false
end

to tree1
  ask turtles [set new? false pd]
  ahead 4 r 15 ahead 8 t r 180 skip 8 r 180 l 15 ahead 4 l 15 t ahead 8 d
end

to tree2Setup
  ca
  crt 1
  set color-inc 9.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color 
    setxy 0 -50
    set heading 0
    pd
  ]
  set len 50
  set swirl? false
  set ball? false
  set tree1? false
  set tree2? true
  set sierpinski? false
  set koch? false
  set figureEight? false
end

to tree2
  ask turtles [set new? false pd]
  ahead 10 r 30 ahead 5 t skip -5 l 60 ahead 5 t skip -5 r 30 skip -10
end

to sierpinskiSetup
  ca
  crt 1
  set color-inc 3.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy 0 -25
    set heading 0
    pd
  ]
  set len 55
  set swirl? false
  set ball? false
  set tree1? false
  set tree2? false
  set sierpinski? true
  set koch? false
  set figureEight? false
end

to sierpinskiTree
  ask turtles [set new? false pd]
  repeat 3
  [
    ahead len
    t
    r 180
    skip len
    r 180
    r 120
  ]
  set len (len / 2)
  d
end

to figureEightSetup
  ca
  crt 1
  set color-inc 9.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy 0 0
    set heading 0
    pd
  ]
  set len 50
  set swirl? false
  set ball? false
  set tree1? false
  set tree2? false
  set sierpinski? false
  set koch? false
  set figureEight? true
end

to figureEightCovering
  ask turtles [set new? false pd]
  repeat 4
  [
    ahead len t r 180 skip len l 90
  ]
  set len (len / 2)
  d
end

to kochSetup
  ca
  crt 1
  set color-inc 5.0
  set init-color 9.0
  ask turtles
  [
    set shape "line"
    set color init-color
    setxy -47 -82
    set heading 0
    pd
  ]
  set len 55
  set swirl? false
  set ball? false
  set tree1? false
  set tree2? false
  set sierpinski? false
  set koch? true
  set figureEight? false

  set first-time-through? true
end

to kochSnowflake
  ask turtles [set new? false pd]
  ifelse (first-time-through?)
  [
    set first-time-through? false
    repeat 3  ; we do these rules three times so that we can get the snowflake shape
    [
      t ahead len l 60 t ahead len r 120 t ahead len l 60 t ahead len r 120
    ]
  ]
  [  ; notice these are the same rules as above, except that we only do them once
    t ahead len l 60 t ahead len r 120 t ahead len l 60 t ahead len r 120
  ]

  set len (len / 3)
  d
end


; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the project:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS.  The project gratefully acknowledges the support of the
; National Science Foundation (REPP program) -- grant number REC #9814682.
;
; Copyright 2001 by Uri Wilensky.  Updated 2001.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2001).  NetLogo L-SystemFractals model.
; http://ccl.northwestern.edu/netlogo/models/L-SystemFractals.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 by Uri Wilensky.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/L-SystemFractals
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
284
17
696
450
100
100
2.0
1
10
1
1
1
0

CC-WINDOW
5
483
705
578
Command Center

BUTTON
101
37
172
70
Go Once
iterate
NIL
1
T
OBSERVER
T
NIL

BUTTON
32
37
87
70
Setup
setup
NIL
1
T
OBSERVER
T
NIL

SLIDER
60
86
218
119
color-inc
color-inc
0.0
100.0
9.0
1.0
1
NIL

SLIDER
60
125
221
158
init-color
init-color
0.0
140.0
9.0
1.0
1
NIL

SLIDER
22
161
136
194
init-x
init-x
-100.0
100.0
0.0
1.0
1
NIL

SLIDER
151
160
266
193
init-y
init-y
-100.0
100.0
0.0
1.0
1
NIL

BUTTON
185
37
240
70
Go
iterate
T
1
T
OBSERVER
T
NIL

BUTTON
15
348
70
381
Swirl
swirlSetup
NIL
1
T
OBSERVER
T
NIL

BUTTON
78
348
133
381
Ball
ballSetup
NIL
1
T
OBSERVER
T
NIL

BUTTON
144
348
199
381
Tree1
tree1Setup
NIL
1
T
OBSERVER
T
NIL

BUTTON
207
348
262
381
Tree2
tree2Setup
NIL
1
T
OBSERVER
T
NIL

BUTTON
15
389
124
425
Sierpinski's Tree
sierpinskiSetup
NIL
1
T
OBSERVER
T
NIL

BUTTON
82
436
208
469
Koch's Snowflake
kochSetup
NIL
1
T
OBSERVER
T
NIL

BUTTON
134
390
276
426
Figure Eight Covering
figureEightSetup
NIL
1
T
OBSERVER
T
NIL

TEXTBOX
5
291
272
342
Examples: Press the buttons to setup examples of L-System Fractals.  Then press the GO or GO ONCE buttons to see them draw.

MONITOR
80
208
206
257
count turtles
count turtles
10
1

@#$#@#$#@
WHAT IS IT?
-----------
This program draws special types of pictures called fractals.  A fractal is a shape that is self-similar - that is, it looks the same no matter how closely you zoom in or out  For instance, a tree can be thought of as a fractal since if you look at the tree as a whole, you see a stick, that is to say the trunk, with branches coming out of it.  Then if you look at a smaller portion of it, say a branch, you see a similar thing, namely, a stick with branches coming out of it.

This model allows you to draw and look at one class of fractals, called L-system fractals.  L-System fractals are made by following a set of rules over and over.  The rules can be few, but a fascinating and complicated fractal can still form.  These rules tell the turtles what to do.  In the beginning, there will be only one turtle for any fractal.  This turtle can do things such as draw a line, or turn to the right or left.  This turtle can also split itself into two turtles. Each new turtle follows the same rules as the original turtle, and draws its own "branch" of the emerging fractal design. 

By using different sets of rules, you can create a wide variety of different fractal designs.


HOW TO USE IT
-------------
Perhaps the best way to start with this program is by looking at examples of some L-system fractals.  In the "Interface" tab, you will find a series of buttons: "Swirl", "Ball", etc.  Each button sets up a different fractal. Some of these examples are famous fractals, such as Sierpinski's tree and Koch's snowflake.  To view these examples, simply click on one of the example buttons and then press the GO button. 

Please be patient while the fractal draws.  Some of these fractals take about 30 seconds to completely draw.  You know that a fractal is done drawing when the button that you clicked, changes back to its original color, a light gray.

You can also have the fractals drawn one step a time.  Once you click an example setup button, instead of clicking the GO button, click on the GO ONCE button.  This draws the fractal by doing the set of rules only one time per click as opposed to continuously, like the GO button.  A final example of a fern or leafy branch can be found by clicking on the SETUP button followed by either the GO ONCE or GO buttons.

If you don't like the location of the fractal on the graphics window you can change it by modifying the value of the following sliders:
The INIT-X slider sets the initial x coordinate of the first turtle.  It changes the horizontal starting location of  the original turtle.
The INIT-Y slider sets the initial y coordinate of the first turtle.  It changes the vertical starting location of  the original turtle.

If you don't like the color scheme of the fractal you can change it by modifying the value of the following sliders:
The INIT-COLOR slider sets the initial color of the first turtle.
The value of the COLOR-INC slider is added to the turtles color anytime a new turtle hatches.

The example buttons and the SETUP button sets up the graphics window to draw a fractal.  Each of the example buttons sets up the graphics window to draw the fractal of the same name.  The SETUP button sets up the graphics window for drawing the rules found in the applyRules procedure in the "Procedures" tab.
 

THINGS TO NOTICE
----------------
Notice the self-similarity of the fractals at each iteration.  What if one were to perform an infinite number of iterations?  Would looking at any piece up close look any different than looking at the whole?  Also notice how the number of turtles in each of the example is multiplied by some number at each iteration.  Does this make sense?  Try to figure out the number of turtles at some arbitrary step n for one or more of the examples.


THINGS TO TRY
-------------
Now that you have played around with settings for the examples provided, why not try making your own fractals.  You can do this by writing a set the following commands in the applyRules function in the "Procedures" tab:
        "t" causes every non-new turtle to create a new turtle with the same heading
        "r <number>" causes every non-new turtle to turn to the right by number degrees
        "l <number>" causes every non-new turtle to turn to the left by number degrees
        "ahead <number>" causes every non-new turtle to draw a line of length number in the direction each is heading
        "f" causes every non-new turtle to draw line of length 1 in the direction each is heading
        "skip <number>" causes every non-new turtle to move forward by number in the direction each is heading without drawing
        "s" causes every non-new turtle to move forward by 1 in the direction each is heading without drawing
        "d" causes all non-new turtles to be destroyed

To make your fractals, you must write a series of these commands into the applyRules function, in between the lines:

;enter your rules here
...
;stop entering in rules

For example, if you wanted to see what kind of a fractal the set of rules 
  ahead 5 t r 45 ahead -2 skip 7 l 30 
would generate, you would just type them into the applyRules procedure as seen below.

to applyRules
;enter your rules here
  ahead 5 t r 45 ahead -2 skip 7 l 30
;stop entering in rules
end

Use the commands above to make your own fractals.  Then change the initial color and color increment values to make the fractal more interesting to look at.  


EXTENDING THE MODEL
-------------------
Try adding switches such as increment-by-random-length or decrement-by-random-degree that could impose a random factor to the movement of the turtles.  Then add to the forward and turning functions, for example, a random value to the number of steps and degrees.  This would increase the realism in a fractal.

Pick up a book on fractals or search on the internet to find fractals that are interesting and try to create them using the rules of L-system fractals.  You may find some resources below.

Try extending the set of rules so that there are more than the basic ones included in this model.  Then use these rules to make new fractals.

Try starting with more than just one turtle, in a different location or heading, and see how that can affect the fractals that you have made.  Does it ruin them or does it make them more interesting and complex?


NETLOGO FEATURES
----------------
Notice the use of agentsets to make some of the commands affect only certain turtles. For example, the reporter WITH is used to isolate non-new turtles and have the rules affect only them.  Also notice how the fractals are formed using several agents following the same rules through the use of the "hatch" primitive, which makes it simple to generate fractals like Sierpinski's tree.


CREDITS AND REFERENCES
----------------------
You may find more information on L-System fractals in the following locations:

This site offers a nice history and explanation of L-system fractals as well as quit a few classic examples of L-systems. 
http://spanky.triumf.ca/www/fractint/LSYS/tutor.html

This site offers an introduction to fractals, including L-system fractals as well as others.
http://www.cs.wpi.edu/~matt/courses/cs563/talks/cbyrd/pres1.html

The Fractal Geometry of Nature by Benoit Mandelbrot

To refer to this model in academic publications, please use: Wilensky, U. (2001).  NetLogo L-System Fractals model. http://ccl.northwestern.edu/netlogo/models/L-SystemFractals. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 2001 by Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/L-SystemFractals for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
ballSetup
repeat 14 [ iterate ]
@#$#@#$#@
@#$#@#$#@
